% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sudokuAlt.R
\name{as.sudoku}
\alias{as.sudoku}
\title{Generic Sudoku Game Constructor}
\usage{
as.sudoku(x, ...)
}
\arguments{
\item{x}{an n^2 x n^2 matrix object to represent the game}

\item{...}{Other additional arguments (currently ignored)}
}
\value{
An object of class 'sudoku'
}
\description{
Construct a Sudoku Game Object
}
\details{
Coerce an object to one that can be used as a sudoku game.
IMPORTANT: games are represented as n^2xn^2 character matrices,
using 1-9 for n=2 or 3, and LETTERS[1:(n^2)] for n = 4 or 5.
}
\examples{
M <- as.sudoku(matrix("", 16, 16))
M[1:4, 1:4] <- matrix(LETTERS[1:16], 4, 4, byrow = TRUE)
sM <- solve(M)
plot(sM)
}
\author{
Bill Venables
}

