% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscreenshow.R
\name{subscreenshow}
\alias{subscreenshow}
\title{Systematic screening of study data for subgroups}
\usage{
subscreenshow(scresults, host = NULL, port = NULL, ColorPoint = "white",
  ColorClicked = "red", ColorSelected = "green", ColorParent = "orange",
  ColorReference = "darkorange", ColorBG = "#424242",
  ColorBGplot = "#424242", ColorText = "#6b6b6b", PreSelectScale = "lin",
  PreSelectTarget = "", PreSelectXAxis = "", pickradius = 5)
}
\arguments{
\item{scresults}{SubScreenResult object with results from a subscreencalc call}

\item{host}{host name or IP address for Shiny display}

\item{port}{port number for Shiny display}

\item{ColorPoint}{Color for the points displaying the subgroup results (defaults to white)}

\item{ColorClicked}{Color of picked points (defaults to red)}

\item{ColorSelected}{Color selected (filtered) subgroups (defaults to green)}

\item{ColorParent}{Color of parent subgroup (defaults to orange)}

\item{ColorReference}{Color of reference line (defaults to darkorange)}

\item{ColorBG}{Background color of the Shiny app}

\item{ColorBGplot}{Background color of the plot}

\item{ColorText}{Color of the legend text}

\item{PreSelectScale}{Scale of y axis "lin" or "log"}

\item{PreSelectTarget}{Preselected target variable (y-axis)}

\item{PreSelectXAxis}{Variable for x-axis}

\item{pickradius}{radius (in pixel) for interactive selection of subgroups}
}
\description{
Start the Shiny based intactive visualization tool to show the subgroup results
generated by subscreencalc.
}
\keyword{analysis}
\keyword{subgroup}
\keyword{visualization}
