% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscore.sx.R
\name{subscore.sx}
\alias{subscore.sx}
\title{Computing subscores using Haberman's method based on both observed total scores and observed subscores.}
\usage{
subscore.sx(test.data)
}
\arguments{
\item{test.data}{A list that contains subscale responses and the total test responses. It 
can be obtained using the function 'data.prep'.}
}
\value{
\item{summary}{Summary of obtained subscores (e.g., mean, sd).}
\item{PRMSE}{PRMSEs of obtained subscores (for Haberman's methods only).}
\item{subscore.original}{Original observed subscores and total score.} 
\item{subscore.sx}{Subscores that are estimated based on both the observed total score and observed subscore.}
}
\description{
This function estimate true subscores based on both observed stotal scores and observed 
subscores using the method introduced by Haberman (2008) <doi:10.3102/1076998607302636>.
}
\examples{
       test.data<-data.prep(scored.data,c(3,15,15,20),
                            c("Algebra","Geometry","Measurement", "Math"))
       
       subscore.sx(test.data) 
       subscore.s(test.data)$Correlation
       subscore.s(test.data)$Disattenuated.correlation
       subscore.sx(test.data)$summary
       subscore.sx(test.data)$PRMSE
       subscore.sx(test.data)$subscore.sx
}
\references{
{
Haberman, S. J. (2008). 
"When can subscores have value?."
 Journal of Educational and Behavioral Statistics, 33(2), 204-229. doi:10.3102/1076998607302636. 
}
}
