% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegOnTot.R
\name{RegOnTot}
\alias{RegOnTot}
\title{Computing subscores using Haberman's method based on observed total scores.}
\usage{
RegOnTot(test.data)
}
\arguments{
\item{test.data}{A list that contains subscale responses and the total test responses. It 
can be obtained using the function 'data.prep'.}
}
\value{
\item{summary}{Summary of obtained subscores (e.g., mean, sd).}
\item{PRMSE}{PRMSEs of obtained subscores (for Haberman's methods only).}
\item{subscore.original}{Original observed subscores and total score.} 
\item{subscore.RegOnTot}{Subscores that are estimated based on the observed total score.}
}
\description{
This function estimates true subscores based on observed total scores 
using the method introduced by Haberman (2008).
}
\examples{
       test.data<-data.prep(scored.data,c(3,15,15,20))
       
       RegOnTot(test.data) 
       
       RegOnTot(test.data)$summary
       RegOnTot(test.data)$PRMSE
       RegOnTot(test.data)$subscore.RegOnTot
}
\references{
{
Haberman, S. J. (2008). 
"When can subscores have value?."
 Journal of Educational and Behavioral Statistics, 33(2), 204-229. 
}
}

