% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heldoutLikelihood.R
\name{heldoutLikelihood}
\alias{heldoutLikelihood}
\title{Heldout Log-Likelihood}
\usage{
heldoutLikelihood(mv, kappa, alpha, missing)
}
\arguments{
\item{mv}{the baseline log-transformed occurrence rate of each word in the 
corpus}

\item{kappa}{the estimated kappa coefficients}

\item{alpha}{the estimated alpha values for the corpus}

\item{missing}{list of which words and documents are in the heldout set}
}
\value{
expected.heldout is the average of the held-out log-likelihood values 
for each document.
}
\description{
Compute the heldout log-likelihood of the STS model
}
\examples{
library("tm"); library("stm"); library("sts")
temp<-textProcessor(documents=gadarian$open.ended.response,
metadata=gadarian, verbose = FALSE)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta, verbose = FALSE)
out$meta$noTreatment <- ifelse(out$meta$treatment == 1, -1, 1)
out_ho <- make.heldout(out$documents, out$vocab)
## low max iteration number just for testing
sts_estimate <- sts(~ treatment*pid_rep, ~ noTreatment, out, K = 3, maxIter = 2)
sm <- sample(x=1:length(out_ho$missing$index), 
size = length(out_ho$missing$index)*0.8, replace = TRUE)
d.h <- list(index = out_ho$missing$index[sm], docs = out_ho$missing$docs[sm])
heldoutLikelihood(mv=sts_estimate$mv, kappa=sts_estimate$kappa, 
alpha=sts_estimate$alpha, missing=d.h)$expected.heldout
}
