% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateAT6.r
\name{calculateAT6}
\alias{calculateAT6}
\title{Calculate Analytical Threshold}
\usage{
calculateAT6(
  data,
  ref,
  amount = NULL,
  weighted = TRUE,
  alpha = 0.05,
  ignore.case = TRUE,
  debug = FALSE
)
}
\arguments{
\item{data}{data.frame containing at least columns 'Sample.Name', 'Marker',
'Allele', and 'Height'.}

\item{ref}{data.frame containing at least columns 'Sample.Name', 'Marker',
and 'Allele'.}

\item{amount}{data.frame containing at least columns 'Sample.Name' and 'Amount'.
If NULL 'data' must contain a column 'Amount'.}

\item{weighted}{logical to calculate weighted linear regression (weight=1/se^2).}

\item{alpha}{numeric [0,1] significance level for the t-statistic.}

\item{ignore.case}{logical to indicate if sample matching should ignore case.}

\item{debug}{logical to indicate if debug information should be printed.}
}
\value{
data.frame with columns 'Amount', 'Height', 'Sd', 'Weight', 'N',
 'Alpha', 'Lower', 'Intercept', and 'AT6'.
}
\description{
Calculate analytical thresholds estimate using linear regression.
}
\details{
Calculate the analytical threshold (AT) according to method 6 as
outlined in the reference. In short serial dilutions are analyzed
and the average peak height is calculated. Linear regression or
Weighted linear regression with amount of DNA as the predictor for
the peak height is performed.
Method 6: A simplified version of the upper limit approach.
AT6 = y-intercept + t-statistic * standard error of the regression.
Assumes the y-intercept is not different from the mean blank signal.
The mean blank signal should be included in the confidence range
('Lower' to 'AT6' in the resulting data frame).
NB! This is an indirect method to estimate AT and should be verified
by other methods. From the reference: A way to determine the validity
of this approach is based on whether the y-intercept +- (1-a)100%
contains the mean blank signal. If the mean blank signal is included
in the y-intercept band, the following relationship [i.e. AT6] can be used
to determine the AT. However, it should be noted that the ATs derived in
this manner need to be calculated for each color and for all preparations
(i.e., different injections, sample preparation volumes, post-PCR cleanup,
etc.).
NB! Quality sensors must be removed prior to analysis.
}
\references{
J. Bregu et.al.,
  Analytical thresholds and sensitivity: establishing RFU thresholds for
  forensic DNA analysis, J. Forensic Sci. 58 (1) (2013) 120-129,
  ISSN 1556-4029, DOI: 10.1111/1556-4029.12008.
\doi{10.1111/1556-4029.12008}
}
\seealso{
\code{\link{calculateAT6_gui}}, \code{\link{calculateAT}},
 \code{\link{calculateAT_gui}}, \code{\link{lm}}
}
