% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listObjects.r
\name{listObjects}
\alias{listObjects}
\title{List Objects}
\usage{
listObjects(env = parent.frame(), obj.class = NULL, debug = FALSE)
}
\arguments{
\item{env}{environment in which to search for objects.}

\item{obj.class}{character string or vector specifying the object class.}

\item{debug}{logical indicating printing debug information.}
}
\value{
character vector with the object names.
}
\description{
Internal helper function to list objects in an environment.
}
\details{
Internal helper function to retrieve a list of objects from a workspace.
Take an environment as argument and optionally an object class.
Returns a list of objects of the specified class in the environment.
}
\examples{
\dontrun{
# List data frames in the workspace.
listObjects(obj.class = "data.frame")
# List functions in the workspace.
listObjects(obj.class = "function")
}

}
