% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableBalance.r
\name{tableBalance}
\alias{tableBalance}
\title{Table Balance}
\usage{
tableBalance(data, scope = "locus", quant = 0.05)
}
\arguments{
\item{data}{data frame from a balance analysis by \code{calculateHb}
and \code{calculateLb}.}

\item{scope}{string, summarize 'global' or 'locus'.}

\item{quant}{numeric, quantile to calculate.}
}
\value{
data.frame with summarized result.
}
\description{
Summarize Hb or Lb analysis data in table format.
}
\details{
Summarize the Hb or Lb analysis in table format with different scope.
(locus, or global). Returns a dataframe with columns for marker name
'Marker', number of allele ratios 'Xb.n', the minimum observed allele ratio
'Xb.Min', the mean allele ratio 'Xb.Mean', its standard deviation 'Xb.Stdv',
the XXth percentile 'Xb.Perc.XX'
For more details see \code{min}, \code{mean}, \code{sd}, \code{quantile}.
}

