% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addData.r
\name{addData}
\alias{addData}
\title{Adds New Data Columns to a Data Frame}
\usage{
addData(data, new.data, by.col, then.by.col = NULL, exact = TRUE,
  ignore.case = TRUE, debug = FALSE)
}
\arguments{
\item{data}{Data frame containing your main data.}

\item{new.data}{Data frame containing information you want to add to 'data'.}

\item{by.col}{character, primary key column.}

\item{then.by.col}{character, secondary key column.}

\item{exact}{logical, TRUE matches keys exact.}

\item{ignore.case}{logical, TRUE ignore case.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame the original data frame containing additional columns.
}
\description{
Adds values from columns in 'new.data' to 'data' by keys.
}
\details{
Information in columns in data frame 'new.data' is added to data frame
'data' based on primary key value in column 'by.col', and optionally on
secondary key values in column 'then.by.col'.
}
\examples{
# Get marker names and alleles for Promega PowerPlex ESX 17.
x <- getKit("ESX17", what="Allele")
# Get marker names and colors for Promega PowerPlex ESX 17.
y <- getKit("ESX17", what="Color")
# Add color information to allele information.
z <- addData(data=x, new.data=y, by.col="Marker")
print(x)
print(y)
print(z)
}

