% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/generateEPG.r
\name{generateEPG}
\alias{generateEPG}
\title{Generate EPG}
\usage{
generateEPG(data, kit, title = NULL, peaks = TRUE, type = "profile",
  collapse = TRUE, silent = FALSE, ignore.case = TRUE, at = 0,
  scale = "free", limit.x = TRUE, label.size = 3, label.angle = 0,
  label.vjust = 1, label.hjust = 0.5, expand = 0.1, debug = FALSE)
}
\arguments{
\item{data}{data frame containing at least columns 'Sample.Name', 'Allele', and 'Marker'.}

\item{kit}{string or integer representing the STR typing kit.}

\item{title}{string providing the title for the EPG.}

\item{peaks}{logical TRUE to plot peaks for distributions using mean peak height.}

\item{type}{character plot type "distr" and "profile".}

\item{collapse}{logical TRUE to add the peak heights of identical alleles peaks within each marker.
NB! Removes off-ladder alleles.}

\item{silent}{logical FALSE to show plot.}

\item{ignore.case}{logical FALSE for case sensitive marker names.}

\item{at}{numeric analytical threshold (Height <= at will not be plotted).}

\item{scale}{character "free" free x and y scale, alternatively "free_y" or "free_x".}

\item{limit.x}{logical TRUE to fix x-axis to size range.
To get a common x scale set scale="free_y" and limit.x=TRUE.}

\item{label.size}{numeric for allele label text size.}

\item{label.angle}{numeric for allele label print angle.}

\item{label.vjust}{numeric for vertical justification of allele labels.}

\item{label.hjust}{numeric for horizontal justification of allele labels.}

\item{expand}{numeric for plot are expansion (to avoid clipping of labels).}

\item{debug}{logical for printing debug information to the console.}
}
\value{
ggplot object.
}
\description{
Visualises an EPG from DNA profiling data.
}
\details{
Generates a electropherogram like plot from 'data' and 'kit'.
If 'Size' is not present it is estimated from kit information and allele values.
If 'Height' is not present a default of 1000 RFU is used.
Off-ladder alleles can be plotted if 'Size' is provided.
There are various options to customise the plot scale and labels.
It is also possible to plot 'distributions' of peak heights.
}

