% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tableStutter}
\alias{tableStutter}
\title{Table stutter}
\usage{
tableStutter(data, scope = "stutter", quant = 0.95)
}
\arguments{
\item{data}{data frame from a stutter analysis by \code{calculateStutter}.}

\item{scope}{string, summarize 'global', by 'locus', or by 'stutter'.}

\item{quant}{numeric, quantile to calculate.}
}
\value{
data.frame with summarized result.
}
\description{
\code{tableStutter} summarizes a stutter analysis in table format.
}
\details{
Summarize the stutter analysis in table format with different scope
(stutter, locus, or global). Returns a dataframe with columns
for marker name 'Marker', stutter type 'Type', number of alleles 'n.alleles',
number of stutters 'n.stutters', mean ratio 'Mean', standard deviation 'Stdv',
the XXth percentile 'Perc.XX', and the maximum observed ratio 'Max'.
For more details see \code{mean}, \code{sd}, \code{quantile}, \code{max}.
}

