% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-non-nums.R
\name{str_nth_non_numeric}
\alias{str_nth_non_numeric}
\alias{str_first_non_numeric}
\alias{str_last_non_numeric}
\title{Extract the \code{n}th non-numeric substring from a string.}
\usage{
str_nth_non_numeric(
  string,
  n,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  commas = FALSE
)

str_first_non_numeric(
  string,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  commas = FALSE
)

str_last_non_numeric(
  string,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = ""
)
}
\arguments{
\item{string}{A string.}

\item{n}{A vector of integerish values. Must be either length 1 or
have length equal to the length of \code{string}. Negative indices count from
the back: while \code{n = 1} and \code{n = 2} correspond to first and second, \code{n = -1} and \code{n = -2} correspond to last and second-last. \code{n = 0} will return
\code{NA}.}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{sci}{Make the search aware of scientific notation e.g. 2e3 is the same
as 2000.}

\item{big_mark}{A character. Allow this character to be used as a thousands
separator. This character will be removed from between digits before they
are converted to numeric. You may specify many at once by pasting them
together e.g. \code{big_mark = ",_"} will allow both commas and underscores.
Internally, this will be used inside a \verb{[]} regex block so e.g. \code{"a-z"}
will behave differently to \code{"az-"}. Most common separators (commas, spaces,
underscores) should work fine.}

\item{commas}{Deprecated. Use \code{big_mark} instead.}
}
\description{
Extract the \code{n}th non-numeric bit of a string where numbers are optionally
defined with decimals, scientific notation and thousand separators.
\itemize{ \item \code{str_first_non_numeric(...)} is just
\code{str_nth_non_numeric(..., n = 1)}. \item \code{str_last_non_numeric(...)} is
just \code{str_nth_non_numeric(..., n = -1)}. }
}
\examples{
strings <- c(
  "abc123def456", "abc-0.12def.345", "abc.12e4def34.5e9",
  "abc1,100def1,230.5", "abc1,100e3,215def4e1,000"
)
str_nth_non_numeric(strings, n = 2)
str_nth_non_numeric(strings, n = -2, decimals = TRUE)
str_first_non_numeric(strings, decimals = TRUE, leading_decimals = FALSE)
str_last_non_numeric(strings, big_mark = ",")
str_nth_non_numeric(strings,
  n = 1, decimals = TRUE, leading_decimals = TRUE,
  sci = TRUE
)
str_first_non_numeric(strings,
  decimals = TRUE, leading_decimals = TRUE,
  sci = TRUE, big_mark = ",", negs = TRUE
)
str_first_non_numeric(c("22", "1.2.3"), decimals = TRUE)
}
\seealso{
Other non-numeric extractors: 
\code{\link{str_extract_non_numerics}()}
}
\concept{non-numeric extractors}
