% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate.R
\name{str_locate_nth}
\alias{str_locate_nth}
\alias{str_locate_first}
\alias{str_locate_last}
\title{Locate the indices of the \code{n}th instance of a pattern.}
\usage{
str_locate_nth(string, pattern, n)

str_locate_first(string, pattern)

str_locate_last(string, pattern)
}
\arguments{
\item{string}{A character vector.}

\item{pattern}{The pattern to look for.

The default interpretation is a regular expression, as described in
\link[stringi:stringi-search-regex]{stringi::stringi-search-regex}.

To match a without regular expression (i.e. as a human would), use
\link[stringr:coll]{coll()}. For details see \code{\link[stringr:regex]{stringr::regex()}}.}

\item{n}{A vector of integerish values. Must be either length 1 or
have length equal to the length of \code{string}. Negative indices count from
the back: while \code{n = 1} and \code{n = 2} correspond to first and second, \code{n = -1} and \code{n = -2} correspond to last and second-last. \code{n = 0} will return
\code{NA}.}
}
\value{
A two-column matrix. The \eqn{i}th row of this matrix gives the start
and end indices of the \eqn{n}th instance of \code{pattern} in the \eqn{i}th
element of \code{string}.
}
\description{
The \code{n}th instance of an pattern will cover a series of character
indices. These functions tell you which indices those are. These functions
are vectorised over all arguments.
}
\details{
\itemize{ \item \code{str_locate_first(...)} is just \code{str_locate_nth(..., n = 1)}.
\item \code{str_locate_last(...)} is just \code{str_locate_nth(..., n = -1)}. }
}
\examples{
str_locate_nth(c("abcdabcxyz", "abcabc"), "abc", 2)
str_locate_nth(c("This old thing.", "That beautiful thing there."),
"\\\\w+", c(2, -2))
str_locate_nth("abc", "b", c(0, 1, 1, 2))

}
\seealso{
Other locators: \code{\link{str_locate_braces}}
}
\concept{locators}
