# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

match_arg_index <- function(arg, choices) {
    .Call(`_strex_match_arg_index`, arg, choices)
}

#' Interleave two vectors of strings.
#'
#' Make a vector of strings where the first element is from `strings1`, the
#' second is from `strings2`, the third is from `strings1`, the fourth is from
#' `strings2`, and so on.
#'
#' `strings1` and `strings2` must be the same length or differ in length only
#' by 1. If `strings2` is longer, it goes first.
#'
#' @param strings1,strings2 Character vectors.
#'
#' @return A character vector.
#'
#' @examples
#' interleave_strings(c("a", "c", "e"), c("b", "d"))
#'
#' @noRd
interleave_strings <- function(strings1, strings2) {
    .Call(`_strex_interleave_strings`, strings1, strings2)
}

interleave_char_lists <- function(strings1, strings2) {
    .Call(`_strex_interleave_char_lists`, strings1, strings2)
}

#' Remove empty strings from a character list.
#'
#' @param char_list A list of character vectors.
#'
#' @return A list of character vectors.
#'
#' @examples
#' str_list_remove_empties(list(c("a", "", "b"), "gg", c("", 1, "")))
#'
#' @noRd
str_list_remove_empties <- function(char_list) {
    .Call(`_strex_str_list_remove_empties`, char_list)
}

#' Get the nth element of each vector in a list of numeric or character
#' vectors.
#'
#' These are faster implementations of procedures that could very easily be
#' done with [purrr::map_dbl] or [purrr::map_chr].
#'
#' This is a wrapper function for [str_list_nth_elems_()] that
#' has better error handling.
#'
#' @param char_list A list of character vectors.
#' @param n The index of the element that you want from each vector. If
#'   `char_list` is of length 1, this can be any length and those indices will
#'   be extracted from `char_list[[1]]`. Otherwise, this must either be of
#'   length 1 or the same length as `char_list`. All of this is to say that
#'   the function is vectorised over this argument.
#'
#' @return A list.
#'
#' @examples
#' str_list_nth_elems_helper(list(c("a", "b", "c"), c("d", "f", "a")), 2)
#' num_list_nth_elems_helper(list(1:5, 0:2), 4)
#'
#' @noRd
str_list_nth_elems_helper <- function(char_list, n) {
    .Call(`_strex_str_list_nth_elems_helper`, char_list, n)
}

#' @rdname str_list_nth_elems_
#' @param num_list A list of numeric vectors.
#' @noRd
num_list_nth_elems_ <- function(num_list, n) {
    .Call(`_strex_num_list_nth_elems_`, num_list, n)
}

lst_char_to_num <- function(x, commas) {
    .Call(`_strex_lst_char_to_num`, x, commas)
}

int_lst_first_col <- function(x) {
    .Call(`_strex_int_lst_first_col`, x)
}

#' rbind all elements of a list.
#'
#' Assumes all elements of list are integer matrices with the same number of
#' columns. Undefined behaviour if not.
#'
#' @param x A list of integer matrices all with the same number of rows.
#' @param x_lens The lengths of the elements of x.
#'
#' @return An integer matrix.
#'
#' @noRd
#'
lst_rbind <- function(x, x_lens) {
    .Call(`_strex_lst_rbind`, x, x_lens)
}

#' rbind the nth rows of all elements of a list.
#'
#' Assumes all elements of list are integer matrices with the same number of
#' columns. Undefined behaviour if not.
#'
#' @param x A list of integer matrices all with the same number of rows.
#' @param x_lens The lengths of the elements of x.
#'
#' @return An integer matrix.
#'
#' @noRd
#'
lst_rbind_nth_rows <- function(x, n) {
    .Call(`_strex_lst_rbind_nth_rows`, x, n)
}

#' Get the locations of strings located by `str_locate()` and the substrings
#' that are left out by `str_locate()`.
#'
#' `str_locate()` tells you where bits of a string matching your pattern are.
#' `str_fullocate()` takes the output of `str_locate()`, figures out which
#' substrings are excluded and includes those too.
#'
#' @param x A two-column integer matrix: the output of str_locate.
#' @param string_length The length of the searched string.
#'
#' @return An even-length integer vector. Each pair of elements defines a
#' substring by the position of the first character and the substring size
#' (this is ideal for feeding into C++'s `string::substr()`).
#'
#' @noRd
NULL

#' Get the unlocated parts of strings.
#'
#' Given a character vector and the output from `str_locate_all()`, get the
#' located _and_ unlocated substrings (not their locations, the actual
#' strings).
#'
#' @param strings A character vector.
#' @param locations The output of `str_locate_all()`.
#'
#' @return A list of character vectors, as output by e.g. `str_extract_all()`.
#'
#' @noRd
fullocated_substrs <- function(strings, locations) {
    .Call(`_strex_fullocated_substrs`, strings, locations)
}

#' Convert a character vector to a numeric vector.
#'
#' This is my cpp best shot at R's `as.numeric()`.
#'
#' @param x A character vector.
#' @param commas Allow comma-separated numbers like 1,000?
#'
#' @return A numeric vector.
#'
#' @noRd
char_to_num <- function(x, commas) {
    .Call(`_strex_char_to_num`, x, commas)
}

