% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_stream.R
\name{write_stream}
\alias{write_stream}
\title{Write a Data Stream to a File}
\usage{
write_stream(
  dsd,
  file,
  n,
  block = 100000L,
  info = FALSE,
  append = FALSE,
  sep = ",",
  header = FALSE,
  row.names = FALSE,
  close = TRUE,
  ...
)
}
\arguments{
\item{dsd}{The DSD object that will generate the data points for output.}

\item{file}{A file name or a R connection to be written to.}

\item{n}{The number of data points to be written. For finite streams, \code{n = -1} writes all available data points.}

\item{block}{Write stream in blocks to improve file I/O speed.}

\item{info}{Save the class/cluster labels and other information columns with the data.}

\item{append}{Append the data to an existing file. If \code{FALSE}, then the file will be overwritten.}

\item{sep}{The character that will separate attributes in a data point.}

\item{header}{A flag that determines if column names will be output
(equivalent to \code{col.names} in \code{\link[=write.table]{write.table()}}).}

\item{row.names}{A flag that determines if row names will be output.}

\item{close}{close stream after writing.}

\item{...}{Additional parameters that are passed to \code{\link[=write.table]{write.table()}}.}
}
\value{
There is no value returned from this operation.
}
\description{
Writes points from a data stream DSD object to a file or a connection.
}
\examples{
# create data and write 10 points to disk
stream <- DSD_Gaussians(k = 3, d = 5)
stream

write_stream(stream, file="data.txt", n = 10, header = TRUE, info = TRUE)

readLines("data.txt")

# clean up
file.remove("data.txt")

# create a finite stream and write all data to disk using n = -1
stream2 <- DSD_Memory(stream, n = 5)
stream2

write_stream(stream2, file="data.txt", n = -1, header = TRUE, info = TRUE)

readLines("data.txt")

# clean up
file.remove("data.txt")
}
\seealso{
\link{write.table}
}
\author{
Michael Hahsler
}
