/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import moa.classifiers.AbstractClassifier;
import moa.classifiers.AttributeClassObserver;
import moa.classifiers.HoeffdingTree;
import weka.core.Instance;

public class LimAttHoeffdingTree
extends HoeffdingTree {
    private static final long serialVersionUID = 1L;
    protected int[] listAttributes;

    public void setlistAttributes(int[] list) {
        this.listAttributes = list;
    }

    public LimAttHoeffdingTree() {
        this.removePoorAttsOption = null;
    }

    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations) {
        return new LimAttLearningNode(initialClassObservations);
    }

    public boolean isRandomizable() {
        return true;
    }

    public static class LimAttLearningNode
    extends HoeffdingTree.ActiveLearningNode {
        private static final long serialVersionUID = 1L;
        protected double weightSeenAtLastSplitEvaluation;
        protected int[] listAttributes;
        protected int numAttributes;

        public LimAttLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public void setlistAttributes(int[] list) {
            this.listAttributes = list;
            this.numAttributes = list.length;
        }

        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
            if (this.listAttributes == null) {
                this.setlistAttributes(((LimAttHoeffdingTree)ht).listAttributes);
            }
            for (int j = 0; j < this.numAttributes; ++j) {
                int i = this.listAttributes[j];
                int instAttIndex = AbstractClassifier.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = (AttributeClassObserver)this.attributeObservers.get(i);
                if (obs == null) {
                    obs = inst.attribute(instAttIndex).isNominal() ? ht.newNominalClassObserver() : ht.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
            }
        }
    }
}

