% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeAll.R
\name{summarizeAll}
\alias{summarizeAll}
\title{Summarize Genotypes and Sequences}
\usage{
summarizeAll(g, write.files = FALSE, label = NULL, ...)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{write.files}{logical determining whether to write .csv files of 
summaries}

\item{label}{optional label for output folder and prefix for files.}

\item{...}{optional arguments to pass on to summary functions.}
}
\value{
If \code{write.files = TRUE}, files are written for by-sample and 
  by-locus summaries, and duplicate genotypes if any are found. If 
  sequences are present, files are written identifying low frequency 
  substitutions and sequence likelihoods.\cr
  The return value is a list with the following elements:
  
\describe{
  \item{by.sample}{data.frame of by-sample summaries}
  \item{\code{by.locus}}{data.frame of by-locus summaries}
  \item{\code{dup.df}}{data.frame identifying potential duplicates}
  \item{\code{by.seq}}{list of low frequency substitutions and haplotype 
    likelihoods for each gene}
}
}
\description{
Conducts a suite of data summaries. Summarizes missing data and 
  homozygosity by individual and locus, and looks for duplicate genotypes 
  (see \code{\link{dupGenotypes}}). For sequence data, identifies low 
  frequency substitutions (see \code{\link{lowFreqSubs}}), and computes 
  sequence likelihoods (see \code{\link{sequenceLikelihoods}}).
}
\seealso{
\code{\link{summarizeInds}}, \code{\link{summarizeLoci}}, 
  \code{\link{dupGenotypes}}, \code{\link{lowFreqSubs}}, 
  \code{\link{sequenceLikelihoods}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
