% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharedLoci.R
\name{sharedLoci}
\alias{sharedLoci}
\alias{propSharedLoci}
\alias{sharedAlleles}
\title{Shared Loci}
\usage{
propSharedLoci(g, type = c("strata", "ids"))

sharedAlleles(g, smry = c("num", "which"))
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{type}{a character vector determining type of pairwise comparsion. Can 
be "strata" for strata or "ids" for individuals.}

\item{smry}{a character vector determining type of summary for 
\code{sharedAlleles}. "which" returns the names of the alleles shared. 
"num" returns the number of alleles shared.}
}
\value{
data.frame summary of pairwise shared loci.
}
\description{
Calculate proportion of alleles and number of loci shared 
  between pairs of individuals or strata.
}
\examples{
data(msats.g)
msats.g <- stratify(msats.g, "fine")

sharedAlleles(msats.g)

\dontrun{
propSharedLoci(msats.g)
}

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
