% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelHaplotypes.R
\name{labelHaplotypes}
\alias{labelHaplotypes}
\alias{labelHaplotypes.default}
\alias{labelHaplotypes.list}
\alias{labelHaplotypes.character}
\alias{labelHaplotypes.gtypes}
\title{Find and label haplotypes}
\usage{
labelHaplotypes(x, prefix = NULL, use.indels = TRUE)

\method{labelHaplotypes}{default}(x, prefix = NULL, use.indels = TRUE)

\method{labelHaplotypes}{list}(x, ...)

\method{labelHaplotypes}{character}(x, ...)

\method{labelHaplotypes}{gtypes}(x, ...)
}
\arguments{
\item{x}{sequences in a \code{character matrix}, \code{list},
or \code{\link{DNAbin}} object, or a haploid \linkS4class{gtypes} object
with sequences.}

\item{prefix}{a character string giving prefix to be applied to numbered
haplotypes. If NULL, haplotypes will be labeled with the first label
from original sequences.}

\item{use.indels}{logical. Use indels when comparing sequences?}

\item{...}{arguments to be passed to \code{labelHaplotypes.default}.}
}
\value{
For \code{character}, \code{list}, or \code{DNAbin}, a list with the following elements:
 \describe{
   \item{haps}{named vector (\code{DNAbin}) or list of named vectors
     (\code{multidina}) of haplotypes for each sequence in \code{x}.}
   \item{hap.seqs}{\code{DNAbin} or \code{multidna} object containing
     sequences for each haplotype.}
   \item{unassigned}{\code{data.frame} listing closest matching haplotypes
     for unassignable sequences with N's and the minimum number of
     substitutions between the two. Will be \code{NULL} if no sequences
     remain unassigned.}
 }

 For \code{gtypes}, a new \code{gtypes} object with unassigned individuals
 stored in the @other slot in an element named \code{'haps.unassigned'} (see
 \code{\link{getOther}}).
}
\description{
Identify and group sequences that share the same haplotype.
}
\details{
If any sequences contain ambiguous bases (N's) they are first
  removed. Then haplotypes are assigned based on the remaining
  sequences. The sequences with N's that were removed are then assigned to
  the new haplotypes if it can be done unambiguously (they match only one
  haplotype with 0 differences once the N's have been removed). If this
  can't be done they are assigned NAs and listed in the
  \code{unassigned} element.
}
\examples{
# create 5 example short haplotypes
haps <- c(
  H1 = "ggctagct",
  H2 = "agttagct",
  H3 = "agctggct",
  H4 = "agctggct",
  H5 = "ggttagct"
)
# draw and label 100 samples
sample.seqs <- sample(names(haps), 100, rep = TRUE)
ids <- paste(sample.seqs, 1:length(sample.seqs), sep = "_")
sample.seqs <- lapply(sample.seqs, function(x) strsplit(haps[x], "")[[1]])
names(sample.seqs) <- ids

# add 1-2 random ambiguities
with.error <- sample(1:length(sample.seqs), 10)
for(i in with.error) {
  num.errors <- sample(1:2, 1)
  sites <- sample(1:length(sample.seqs[[i]]), num.errors)
  sample.seqs[[i]][sites] <- "n"
}

hap.assign <- labelHaplotypes(sample.seqs, prefix = "Hap.")
hap.assign

}
\seealso{
\code{\link{expandHaplotypes}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
