% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/hap.freqs.R
\name{hap.freqs}
\alias{hap.freqs}
\title{Haplotype Frequencies}
\usage{
hap.freqs(g)
}
\arguments{
\item{g}{a \code{\link{gtypes}} object.}
}
\value{
A table of haplotype frequencies.
}
\description{
Create a table of haplotype frequencies in each strata.
}
\note{
Function assumes that haplotypes have been already labelled. If not, use
  \code{\link{label.haplotypes}} first.
}
\examples{
data(dolph.strata)
data(dolph.haps)

mtdna <- gtypes(dolph.strata, id.col = 1, strata.col = 2, locus.col = 4, dna.seq = dolph.haps)
hap.freqs(mtdna)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

