% Generated by roxygen2 (4.0.2): do not edit by hand
\name{nucleotide.divergence}
\alias{nucleotide.divergence}
\title{Nucleotide Divergence}
\usage{
nucleotide.divergence(g, probs = c(0, 0.025, 0.5, 0.975, 1), ...)
}
\arguments{
\item{g}{a \code{\link{gtypes}} object.}

\item{probs}{a numeric vector of probabilities of the pairwise distance distributions with
values in \code{[0,1]}.}

\item{...}{arguments passed to \code{\link[ape]{dist.dna}} such as
  \code{model} or \code{pairwise.deletion}.}
}
\value{
a list with summaries of the \code{within} and \code{between} strata
  pairwise distances including Nei's dA.
}
\description{
Calculate Nei's dA between strata, and distributions of
  between- and within-strata nucleotide divergence (sequence distance).
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Nei, M., and S. Kumar (2000) Molecular Evolution and Phylogenetics.
  Oxford University Press, Oxford. (dA: pp. 256, eqn 12.67)
}

