#' @export wright.fst
#' 
#' @title Wright's Fst
#' @description Calcualte Wright's Fst from Ne, dispersal, and generation time.
#' 
#' @param Ne Effective population size.
#' @param dispersal migration rate in terms of probability of an individual migrating in a generation.
#' @param gen.time number of generations since ancestral population.
#' 
#' @author Eric Archer \email{eric.archer@@noaa.gov}

wright.fst <- function(Ne, dispersal, gen.time) 1 / (4 * Ne * dispersal * gen.time + 1)