% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdata_gen.R
\name{simdata_gen}
\alias{simdata_gen}
\title{Multi-dimension simulation function for Genetic SPM (multidimensional GenSPM)}
\usage{
simdata_gen(N = 100, a = -0.05, f1 = 80, Q = 2e-08, f = 80, b = 5,
  mu0 = 1e-05, theta = 0.08, ystart = 80, tstart = 30, tend = 105,
  dt = 1, p0 = 0.25)
}
\arguments{
\item{N}{Number of individuals}

\item{a}{A k by k matrix, which characterize the rate of the adaptive response.}

\item{f1}{A particular state, which is a deviation from the normal (or optimal). This is a vector with length of k.}

\item{Q}{A matrix k by k, which is a non-negative-definite symmetric matrix.}

\item{f}{A vector-function (with length k) of the normal (or optimal) state.}

\item{b}{A diffusion coefficient, k by k matrix.}

\item{mu0}{mortality at start period of time.}

\item{theta}{A displacement coefficient of the Gompertz function.}

\item{ystart}{A vector with length equal to number of dimensions used, defines starting values of covariates.}

\item{tstart}{A number that defines starting time (30 by default).}

\item{tend}{A number, defines final time (105 by default).}

\item{dt}{A time step (1 by default).}

\item{p0}{A proportion of carriers and non-carriers in a population (default p=0.25).}
}
\value{
A table with simulated data.
}
\description{
Multi-dimension simulation function for Genetic SPM (multidimensional GenSPM)
}
\examples{
library(stpm)
data <- simdata_gen(N=100, ystart=80)
head(data)

}
\references{
Arbeev, K.G. et al (2009). Genetic model for longitudinal studies of aging, health, and longevity

Akushevich I., Kulminski A. and Manton K. (2005), Life tables with covariates: Dynamic model 
for Nonlinear Analysis of Longitudinal Data. Mathematical Population Studies, 12(2), pp.: 51-80.
<DOI:10.1080/08898480590932296>.
}

