% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdata_cont.R
\name{simdata_cont}
\alias{simdata_cont}
\title{Multi-dimensional simulation function for continuous trait.}
\usage{
simdata_cont(N = 100, a = -0.05, f1 = 80, Q = 2e-08, f = 80, b = 5,
  mu0 = 2e-05, theta = 0.08, step = 1, tstart = 30, tend = 105,
  ystart = 80, sd0 = 2, k = 1)
}
\arguments{
\item{N}{Number of individuals.}

\item{a}{A k by k matrix, which characterize the rate of the adaptive response.}

\item{f1}{A particular state, which if a deviation from the normal (or optimal). This is a vector with length of k.}

\item{Q}{A matrix k by k, which is a non-negative-definite symmetric matrix.}

\item{f}{A vector-function (with length k) of the normal (or optimal) state.}

\item{b}{A diffusion coefficient, k by k matrix.}

\item{mu0}{mortality at start period of time.}

\item{theta}{A displacement coefficient of the Gompertz function.}

\item{step}{a discrete step size between two observations. A random uniform value is then added to this step size.}

\item{tstart}{A number that defines starting time (30 by default).}

\item{tend}{A number, defines final time (105 by default).}

\item{ystart}{A vector with length equal to number of dimensions used, defines starting values of covariates.}

\item{sd0}{a standard deviation for modelling the next covariate value.}

\item{k}{number of dimensions (k = 1 by default).}
}
\value{
A table with simulated data.
}
\description{
Multi-dimensional simulation function for continuous trait.
}
\examples{
library(stpm)
dat <- simdata_cont(N=50)
head(dat)

}
\references{
Yashin, A.I. et al (2007). Stochastic model for analysis of longitudinal data on aging 
and mortality. Mathematical Biosciences, 208(2), 538-551.<DOI:10.1016/j.mbs.2006.11.006>.
}

