% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od2odf}
\alias{od2odf}
\title{Extract coordinates from OD data}
\usage{
od2odf(flow, zones)
}
\arguments{
\item{flow}{A data frame representing origin-destination data.
The first two columns of this data frame should correspond
to the first column of the data in the zones. Thus in \code{\link[=cents_sf]{cents_sf()}},
the first column is geo_code. This corresponds to the first two columns
of \code{\link[=flow]{flow()}}.}

\item{zones}{A spatial object representing origins (and destinations
if no separate destinations object is provided) of travel.}
}
\description{
Extract coordinates from OD data
}
\details{
Origin-destination (OD) data is often provided
in the form of 1 line per OD pair, with zone codes of the trip origin in the first
column and the zone codes of the destination in the second column
(see the \href{https://docs.ropensci.org/stplanr/articles/stplanr-od.html}{\code{vignette("stplanr-od")}}) for details.
\code{od2odf()} creates an 'origin-destination data frame', with columns containing
origin and destination codes (\code{flow}) that match the first column in a
a spatial (polygon or point \code{sf}) object (\code{zones}).

The function returns a data frame with coordinates for the origin and destination.
}
\examples{
od2odf(flow[1:2, ], zones_sf)
}
\seealso{
Other od: 
\code{\link{od2line}()},
\code{\link{od_aggregate_from}()},
\code{\link{od_aggregate_to}()},
\code{\link{od_coords}()},
\code{\link{od_coords2line}()},
\code{\link{od_id}},
\code{\link{od_id_order}()},
\code{\link{od_oneway}()},
\code{\link{od_to_odmatrix}()},
\code{\link{odmatrix_to_od}()},
\code{\link{points2flow}()},
\code{\link{points2odf}()}
}
\concept{od}
