% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linefuns.R
\name{line_segment1}
\alias{line_segment1}
\title{Segment a single line, using lwgeom or rsgeo}
\usage{
line_segment1(l, n_segments = NA, segment_length = NA)
}
\arguments{
\item{l}{A spatial lines object}

\item{n_segments}{The number of segments to divide the line into}

\item{segment_length}{The approximate length of segments in the output (overrides n_segments if set)}
}
\description{
Segment a single line, using lwgeom or rsgeo
}
\examples{
l <- routes_fast_sf[2, ]
l_seg2 <- line_segment1(l = l, n_segments = 2)
# Test with rsgeo (must be installed):
# l_seg2_rsgeo = line_segment1(l = l, n_segments = 2)
# waldo::compare(l_seg2, l_seg2_rsgeo)
l_seg3 <- line_segment1(l = l, n_segments = 3)
l_seg_100 <- line_segment1(l = l, segment_length = 100)
l_seg_1000 <- line_segment1(l = l, segment_length = 1000)
plot(sf::st_geometry(l_seg2), col = 1:2, lwd = 5)
plot(sf::st_geometry(l_seg3), col = 1:3, lwd = 5)
plot(sf::st_geometry(l_seg_100), col = seq(nrow(l_seg_100)), lwd = 5)
plot(sf::st_geometry(l_seg_1000), col = seq(nrow(l_seg_1000)), lwd = 5)
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_breakup}()},
\code{\link{line_midpoint}()},
\code{\link{line_segment}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_segments}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()}
}
\concept{lines}
