% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linefuns.R
\name{line_bearing}
\alias{line_bearing}
\title{Find the bearing of straight lines}
\usage{
line_bearing(l, bidirectional = FALSE)
}
\arguments{
\item{l}{A spatial lines object}

\item{bidirectional}{Should the result be returned in a bidirectional format?
Default is FALSE. If TRUE, the same line in the oposite direction would have the same bearing}
}
\description{
This function returns the
bearing (in degrees relative to north) of lines.
}
\details{
Returns a boolean vector. TRUE means that the associated line is in fact a point
(has no distance). This can be useful for removing data that will not be plotted.
}
\examples{
l <- flowlines_sf[1:5, ]
bearings_sf_1_9 <- line_bearing(l)
bearings_sf_1_9 # lines of 0 length have NaN bearing
b <- line_bearing(l, bidirectional = TRUE)
r <- routes_fast_sf[1:5, ]
b2 <- line_bearing(r, bidirectional = TRUE)
plot(b, b2)
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_breakup}()},
\code{\link{line_midpoint}()},
\code{\link{line_segment1}()},
\code{\link{line_segment}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_segments}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()}
}
\concept{lines}
