% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnet_join.R
\name{rnet_join}
\alias{rnet_join}
\title{Join route networks}
\usage{
rnet_join(
  rnet_x,
  rnet_y,
  dist = 5,
  length_y = TRUE,
  key_column = 1,
  subset_x = TRUE,
  dist_subset = NULL,
  segment_length = 0,
  endCapStyle = "FLAT",
  contains = TRUE,
  max_angle_diff = NULL,
  ...
)
}
\arguments{
\item{rnet_x}{Target route network, the output will have the same geometries
as features in this object.}

\item{rnet_y}{Source route network. Columns from this route network object will
be copied across to the new network.}

\item{dist}{The buffer width around rnet_y in meters. 1 m by default.}

\item{length_y}{Add a new column called \code{length_y}? Useful when joining based on
length of segments (e.g. weighted mean). \code{TRUE} by default.}

\item{key_column}{The index of the key (unique identifier) column in \code{rnet_x}.}

\item{subset_x}{Subset the source route network by the target network before
creating buffers? This can lead to faster and better results. Default:
\code{TRUE}.}

\item{dist_subset}{The buffer distance in m to apply when breaking up the
source object \code{rnet_y}. Default: 5.}

\item{segment_length}{Should the source route network be split?
\code{0} by default, meaning no splitting. Values above 0 split the source
into linestrings with a max distance. Around 5 (m) may be a sensible
default for many use cases, the smaller the value the slower the process.}

\item{endCapStyle}{Type of buffer. See \code{?sf::st_buffer} for details}

\item{contains}{Should the join be based on \code{sf::st_contains} or \code{sf::st_intersects}?
\code{TRUE} by default. If \code{FALSE} the centroid of each segment of \code{rnet_y} is
used for the join. Note: this can result in incorrectly assigning values
on sideroads, as documented in \href{https://github.com/ropensci/stplanr/issues/520}{#520}.}

\item{max_angle_diff}{The maximum angle difference between x and y nets for a value
to be returned}

\item{...}{Additional arguments passed to \code{rnet_subset}.}
}
\description{
This is a spatial join function that is enables adding columns to a
'target' route network from a 'source' route
network that contains the base geometry, e.g. from OSM
}
\details{
The output is an sf object containing polygons representing
buffers around the route network in \code{rnet_x}.
The examples below demonstrate how to join attributes from
a route network object created with the function \code{\link[=overline]{overline()}} onto
OSM geometries.

Note: The main purpose of this function is to join an ID from \code{rnet_x}
onto \code{rnet_y}. Subsequent steps, e.g. with \code{\link[dplyr:mutate-joins]{dplyr::inner_join()}}
are needed to join the attributes back onto \code{rnet_x}.
There are rarely 1-to-1 relationships between spatial network geometries
so we take care when using this function.

See \href{https://github.com/ropensci/stplanr/issues/505}{#505} for details
and a link to an interactive example of inputs and outputs shown below.
}
\examples{
library(sf)
library(dplyr)
# Uncomment for interactive examples:
plot(st_geometry(route_network_small))
plot(osm_net_example$geometry, lwd = 5, col = "grey", add = TRUE)
plot(route_network_small["flow"], add = TRUE)
rnetj = rnet_join(osm_net_example, route_network_small, dist = 9)
rnetj2 = rnet_join(osm_net_example, route_network_small, dist = 9, segment_length = 10)
# library(mapview)
# mapview(rnetj, zcol = "flow") +
#   mapview(rnetj2, zcol = "flow") +
#   mapview(route_network_small, zcol = "flow")
plot(sf::st_geometry(rnetj))
plot(rnetj["flow"], add = TRUE)
plot(rnetj2["flow"], add = TRUE)
plot(route_network_small["flow"], add = TRUE)
summary(rnetj2$length_y)
rnetj_summary = rnetj2 \%>\%
  filter(!is.na(length_y)) \%>\%
  sf::st_drop_geometry() \%>\%
  group_by(osm_id) \%>\%
    summarise(
      flow = weighted.mean(flow, length_y, na.rm = TRUE),
      )
osm_joined_rnet = dplyr::left_join(osm_net_example, rnetj_summary)
plot(sf::st_geometry(route_network_small))
plot(route_network_small["flow"], lwd = 3, add = TRUE)
plot(sf::st_geometry(osm_joined_rnet), add = TRUE)
# plot(osm_joined_rnet[c("flow")], lwd = 9, add = TRUE)
# Improve fit between geometries and performance by subsetting rnet_x
osm_subset = rnet_subset(osm_net_example, route_network_small, dist = 5)
osm_joined_rnet = dplyr::left_join(osm_subset, rnetj_summary)
plot(route_network_small["flow"])
# plot(osm_joined_rnet[c("flow")])
# mapview(joined_network) +
#   mapview(route_network_small)
}
