% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node-funs.R
\name{route_split}
\alias{route_split}
\title{Split route in two at point on or near network}
\usage{
route_split(r, p)
}
\arguments{
\item{r}{An \code{sf} object with one feature containing a linestring geometry to be split}

\item{p}{A point represented by an \code{sf} object the will split the \code{route}}
}
\value{
An sf object with 2 feature
}
\description{
Split route in two at point on or near network
}
\examples{
sample_routes <- routes_fast_sf[2:6, NULL]
r <- sample_routes[2, ]
p <- sf::st_sfc(sf::st_point(c(-1.540, 53.826)), crs = sf::st_crs(r))
plot(r$geometry, lwd = 9, col = "grey")
plot(p, add = TRUE)
r_split <- route_split(r, p)
plot(r_split, col = c("red", "blue"), add = TRUE)
}
