% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toptail.R
\name{toptail_buff}
\alias{toptail_buff}
\title{Clip the beginning and ends SpatialLines to the edge of SpatialPolygon borders}
\usage{
toptail_buff(l, buff, ...)
}
\arguments{
\item{l}{A SpatialLines object}

\item{buff}{A SpatialPolygons object to act as the buffer}

\item{...}{Arguments passed to rgeos::gBuffer()}
}
\description{
Takes lines and removes the start and end point, to a distance determined
by the nearest polygon border.
}
\examples{
r_toptail <- toptail_buff(routes_fast, zones)
sel <- row.names(routes_fast) \%in\% row.names(r_toptail)
rf_cross_poly <- routes_fast[sel, ]
plot(zones)
plot(routes_fast, col = "blue", lwd = 4, add = TRUE)
# note adjacent lines removed
plot(rf_cross_poly, add = TRUE, lwd = 2)
plot(r_toptail, col = "red", add = TRUE)
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_match}()},
\code{\link{line_midpoint}()},
\code{\link{line_sample}()},
\code{\link{line_segment}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_sample_length}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{onewayid}()},
\code{\link{points2line}()},
\code{\link{toptailgs}()},
\code{\link{update_line_geometry}()}
}
\concept{lines}
