% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route.R
\name{route_dodgr}
\alias{route_dodgr}
\title{Route on local data using the dodgr package}
\usage{
route_dodgr(from = NULL, to = NULL, l = NULL, net = NULL)
}
\arguments{
\item{from}{An object representing origins
(if lines are provided as the first argument, from is assigned to \code{l})}

\item{to}{An object representing destinations}

\item{l}{Only needed if from and to are empty, in which case this
should be a spatial object representing desire lines}

\item{net}{sf object representing the route network}
}
\description{
Route on local data using the dodgr package
}
\examples{
# from <- matrix(stplanr::geo_code("pedallers arms leeds"), ncol = 2)
from <- matrix(c(-1.5327711, 53.8006988), ncol = 2)
# to <- matrix(stplanr::geo_code("gzing"), ncol = 2)
to <- matrix(c(-1.527937, 53.8044309), ncol = 2)
pts <- rbind(from, to)
colnames(pts) = c("X", "Y")
# net <- dodgr::dodgr_streetnet(pts = pts, expand = 0.1)
# osm_net_example <- net[c("highway", "name", "lanes", "maxspeed")]
r <- route_dodgr(from, to, net = osm_net_example)
plot(osm_net_example$geometry)
plot(r, add = TRUE, col = "red", lwd = 5)
}
\seealso{
Other routes: \code{\link{line2routeRetry}},
  \code{\link{line2route}}, \code{\link{nearest2spdf}},
  \code{\link{route_cyclestreet}},
  \code{\link{route_graphhopper}},
  \code{\link{route_local}}, \code{\link{route_osrm}},
  \code{\link{route_transportapi_public}},
  \code{\link{route}}, \code{\link{viaroute2sldf}},
  \code{\link{viaroute}}
}
\concept{routes}
