% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmfunctions.R
\name{viaroute}
\alias{viaroute}
\title{Query OSRM service and return json string result}
\usage{
viaroute(startlat = NULL, startlng = NULL, endlat = NULL, endlng = NULL,
  viapoints = NULL, osrmurl = "http://router.project-osrm.org", zoom = 18,
  instructions = TRUE, alt = TRUE, geometry = TRUE, uturns = TRUE)
}
\arguments{
\item{startlat}{A single value or vector containing latitude(s) of the start
of routes.}

\item{startlng}{A single value or vector containing longitude(s) of the end
of routes.}

\item{endlat}{A single value or vector containing latitude(s) of the end of
routes.}

\item{endlng}{A single value or vector containing longitude(s) of the end
of routes.}

\item{viapoints}{A list of dataframes containing latitude (first column),
longitude (second) column for points to use for each route. Optionally a
third column containing a boolean value indicating if u-turns are allowed
at each viapoint.}

\item{osrmurl}{URL for OSRM sservice, e.g. an osrm instance running on localhost. By default this is \code{"http://router.project-osrm.org"}.}

\item{zoom}{Zoom level for route geometry (0 to 18) (default = 18). Higher values are more detailed.}

\item{instructions}{Boolean value to return instructions (default = TRUE).}

\item{alt}{Boolean value to return alternative routes (default = TRUE).}

\item{geometry}{Boolean value to return route geometries (default = TRUE).}

\item{uturns}{Boolean value to allow uturns at via points (default = TRUE).}
}
\description{
Query OSRM service and return json string result
}
\section{Details}{

Constructs the query URL used with the OSRM HTTP API and returns a string
or vector of strings with the json-encoded results. Can be used in
conjunction with the viaroute2sldf function.
}
\examples{
\dontrun{
  exroutes <- viaroute(50, 0, 51, 1)
  r1 <- viaroute2sldf(exroutes)
  exroutes <- viaroute(50, 0, 51, 1, zoom = 4)
  r2 <- viaroute2sldf(exroutes)
  # Requires mapview to be installed
  # Show the difference between outputs with different zoom levels
  mapview::mapview(r1) +
   mapview::mapview(r2, color = "blue")
  exroutes <- viaroute(viapoints=list(data.frame(x=c(-33.5,-33.6,-33.7),y=c(150,150.1,150.2))))
  r <- viaroute2sldf(exroutes)
  plot(r)
}
}

