% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{sammon}
\alias{sammon}
\title{Wrapper to \code{sammon} for S3 class}
\usage{
sammon(d, y = NULL, k = 2, ...)
}
\arguments{
\item{d}{a distance structure such as that returned by 'dist' or a full symmetric matrix.  Data are assumed to be dissimilarities or relative distances, but must be positive except for self-distance.  This can contain missing values.}

\item{y}{An initial configuration. If NULL, 'cmdscale' is used to provide the classical solution.  (If there are missing values in 'd', an initial configuration must be provided.)  This must not have duplicates.}

\item{k}{The dimension of the configuration}

\item{...}{Additional parameters passed to \code{sammon}, see \code{\link{sammon}}}
}
\value{
An object of class 'sammonE' that inherits from \code{\link{sammon}}. This function only adds an extra slot to the list with the call, adds column labels to the $points and assigns S3 classes 'sammonE', 'cmdscale'. It also adds a slot obsdiss with normalized dissimilarities.
}
\description{
Wrapper to \code{sammon} for S3 class
}
\details{
overloads MASS::sammon and adds class attributes for which there are methods. The functionality is duplicated in the cops package.
}
