% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.stp.R
\name{print.stp}
\alias{print.stp}
\title{Print a \code{stp} object}
\usage{
\method{print}{stp}(x, ...)
}
\arguments{
\item{x}{An object of class \code{stp}}

\item{...}{additional unused argument}
}
\description{
It prints the main information on the spatio-temporal point pattern
stored in the \code{stp} object: the number of points; the enclosing spatial window;
the temporal time period.
}
\examples{

\dontrun{

set.seed(2)
df <- data.frame(cbind(runif(100), runif(100), runif(100)))

stp1 <- stp(df)
stp1

}




}
\seealso{
\link{stp}, \link{summary.stp}, \link{plot.stp}
}
\author{
Nicoletta D'Angelo
}
