% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smvrnorm.R
\name{smvrnorm}
\alias{smvrnorm}
\title{Simulate from a Multivariate Normal Distribution}
\usage{
smvrnorm(
  n = 1,
  mu,
  sigma,
  tol = 1e-06,
  empirical = FALSE,
  eispack = FALSE,
  seed
)
}
\arguments{
\item{n}{the number of observations to simulate}

\item{mu}{a vector of means}

\item{sigma}{a positive-definite symmetric matrix specifying the covariance matrix of the variables.}

\item{tol}{tolerance (relative to largest variance) for numerical lack of positive-definiteness in \code{sigma}.}

\item{empirical}{logical. If true, \code{mu} and \code{sigma} specify the empirical not population mean and covariance matrix.}

\item{eispack}{logical. values other than FALSE result in an error}

\item{seed}{set an optional seed}
}
\value{
The function returns simulated data from a multivariate normal distribution.
}
\description{
\code{smvrnorm()} simulates data from a multivariate normal distribution.
}
\details{
This is a simple port and rename of \code{mvrnorm()} from the \pkg{MASS} package. I elect
to plagiarize/port it because the \pkg{MASS} package conflicts with a lot of things in my workflow,
especially \code{select()}. This is useful for "informal Bayes" approaches to generating quantities
of interest from a regression model.
}
\examples{

M1 <- lm(mpg ~ disp + cyl, mtcars)

smvrnorm(100, coef(M1), vcov(M1))

}
\references{
B. D. Ripley (1987) \emph{Stochastic Simulation.} Wiley. Page 98.
}
