% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_model_expressions.R
\name{tidy_model_expressions}
\alias{tidy_model_expressions}
\title{Expressions with statistics for tidy regression dataframes}
\usage{
tidy_model_expressions(
  data,
  statistic = NULL,
  k = 2L,
  effsize.type = "omega",
  ...
)
}
\arguments{
\item{data}{A tidy dataframe from regression model object.}

\item{statistic}{Which statistic is to be displayed (either \code{"t"} or \code{"f"}or
\code{"z"} or \code{"chi"}) in the expression.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"eta"} (partial eta-squared) or \code{"omega"} (partial
omega-squared).}

\item{...}{Currently ignored.}
}
\description{
Expressions with statistics for tidy regression dataframes
}
\note{
This is an \strong{experimental} function and may change in the future. Please do
not use it yet in your workflow.
}
\examples{
set.seed(123)

# tidy dataframe
df <- tidy_model_parameters(lm(wt ~ am * cyl, mtcars))

# create a column containing expressions
tidy_model_expressions(df, statistic = "t")
}
