% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_corr_test_expressions.R
\name{corr_objects}
\alias{corr_objects}
\title{Create all needed objects for correlation matrix.}
\usage{
corr_objects(
  data,
  ci = FALSE,
  corr.method = "pearson",
  p.adjust.method = "none",
  beta = 0.1,
  k = 2,
  ...
)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken. Only numeric variables should be present.}

\item{ci}{By default, confidence intervals are found.  However, this leads to a noticable slowdown of speed, particularly for large problems.  So, for just the rs, ts and ps, set ci=FALSE}

\item{corr.method}{A character string indicating which correlation
coefficient is to be computed (\code{"pearson"} (default) or \code{"kendall"} or
\code{"spearman"}). \code{"robust"} can also be entered but only if \code{output} argument
is set to either \code{"correlations"} or \code{"p-values"}. The robust correlation
used is percentage bend correlation (see \code{?WRS2::pball}). Abbreviations
will also work: \code{"p"} (for parametric/Pearson's \emph{r}), \code{"np"}
(nonparametric/Spearman's \emph{rho}), \code{"r"} (robust).}

\item{p.adjust.method}{What adjustment for multiple tests should be used?
(\code{"holm"}, \code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"},
\code{"fdr"}, \code{"none"}). See \code{stats::p.adjust} for details about why to use
\code{"holm"} rather than \code{"bonferroni"}). Default is \code{"none"}. If adjusted
\emph{p}-values are displayed in the visualization of correlation matrix, the
\strong{adjusted} \emph{p}-values will be used for the \strong{upper} triangle, while
\strong{unadjusted} \emph{p}-values will be used for the \strong{lower} triangle of the
matrix.}

\item{beta}{A numeric bending constant for percentage bend robust correlation
coefficient (Default: \code{0.1}).}

\item{k}{Decides the number of decimal digits to be displayed
(Default: \code{2}).}

\item{...}{Currently ignored.}
}
\value{
A list with all needed objects for displaying correlation tests in a
correlation matrix visualization.
}
\description{
This function is mostly useful in the context of
\code{ggstatsplot::ggcorrmat}. It returns the correlation matrix, \emph{p}-value
matrix, and a correlation object from \code{psych}/\code{WRS2} package that contains
all the details about the test.
}
\note{
This is \strong{not} a stable function and would likely to either change or
completely go away in future. So avoid using it in your workflows.
}
\examples{
# only numeric variables
df <- purrr::keep(WRS2::diet, purrr::is_bare_numeric)

# using function
corr_objects(df)
}
