/*
 * Decompiled with CFR 0.152.
 */
package ints;

import ints.CharArray;
import ints.IntList;
import ints.PackedIntArray;
import ints.UnsignedByteArray;
import ints.WrappedIntArray;
import java.util.Arrays;

public interface IntArray {
    public int size();

    public int get(int var1);

    public static int[] toArray(IntArray intArray) {
        int[] nArray = new int[intArray.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = intArray.get(i);
        }
        return nArray;
    }

    public static String asString(IntArray intArray) {
        return Arrays.toString(IntArray.toArray(intArray));
    }

    public static boolean equals(IntArray intArray, IntArray intArray2) {
        if (intArray == intArray2) {
            return true;
        }
        if (intArray.size() != intArray2.size()) {
            return false;
        }
        int n = intArray.size();
        for (int i = 0; i < n; ++i) {
            if (intArray.get(i) == intArray2.get(i)) continue;
            return false;
        }
        return true;
    }

    public static int max(IntArray intArray) {
        int n = Integer.MIN_VALUE;
        int n2 = intArray.size();
        for (int i = 0; i < n2; ++i) {
            if (intArray.get(i) <= n) continue;
            n = intArray.get(i);
        }
        return n;
    }

    public static int min(IntArray intArray) {
        int n = Integer.MAX_VALUE;
        int n2 = intArray.size();
        for (int i = 0; i < n2; ++i) {
            if (intArray.get(i) >= n) continue;
            n = intArray.get(i);
        }
        return n;
    }

    public static IntArray create(int[] nArray, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n <= 16) {
            return new PackedIntArray(nArray, n);
        }
        if (n <= 256) {
            return new UnsignedByteArray(nArray, n);
        }
        if (n <= 65536) {
            return new CharArray(nArray, n);
        }
        return new WrappedIntArray(nArray, n);
    }

    public static IntArray create(IntList intList, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n <= 16) {
            return new PackedIntArray(intList, n);
        }
        if (n <= 256) {
            return new UnsignedByteArray(intList, n);
        }
        if (n <= 65536) {
            return new CharArray(intList, n);
        }
        return new WrappedIntArray(intList, n);
    }
}

