% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSGompertz.R
\name{SSGompertz}
\alias{SSGompertz}
\alias{G4.fun}
\alias{G3.fun}
\alias{G2.fun}
\alias{NLS.G4}
\alias{NLS.G3}
\alias{NLS.G2}
\title{Gompertz equations}
\usage{
G4.fun(predictor, b, c, d, e)
G3.fun(predictor, b, d, e)
G2.fun(predictor, b, e)
NLS.G4(predictor, b, c, d, e)
NLS.G3(predictor, b, d, e)
NLS.G2(predictor, b, e)
}
\arguments{
\item{predictor}{a numeric vector of values at which to evaluate the model}

\item{b}{model parameter (slope at inflection point)}

\item{c}{model parameter (lower asymptote)}

\item{d}{model parameter (higher asymptote)}

\item{e}{model parameter (abscissa at inflection point)}
}
\value{
All these functions return a numeric value.
}
\description{
These functions provide the Gompertz equations with 4 (G4.fun), 3 (G3.fun)
and 2 (G2.fun) parameters with self-starter for the \code{\link{nls}}
function (NLS.G4, NLS.G3 and NLS.G2).
}
\details{
The Gompertz equation is parameterised as:
\deqn{ f(x) = c + (d - c) \, \exp \left[-exp(-b (x - e))\right] }
It is a sygmoidally shaped curve and it is asymmetric about its inflection
point. For the 3- and 2-parameter model c is equal to 0, while for the
2-parameter model d is equal to 1.
}
\examples{
data(beetGrowth)
mod3 <- nls(weightInf ~ NLS.G3(DAE, b, c, d), data = beetGrowth)
summary(mod3)
plot(mod3)
}
\author{
Andrea Onofri
}
