% Generated by roxygen2 (4.0.1): do not edit by hand
\name{statebins_continuous}
\alias{statebins_continuous}
\title{Create a new ggplot-based "statebin" chart for USA states (continuous scale)}
\usage{
statebins_continuous(state_data, state_col = "state", value_col = "value",
  text_color = "black", font_size = 3, state_border_col = "white",
  legend_title = "Legend", legend_position = "top", brewer_pal = "PuBu",
  plot_title = "", title_position = "bottom")
}
\arguments{
\item{state_data}{data frame of states and values to plot}

\item{state_col}{column name in \code{state_data} that has the states. no duplicates and can be names (e.g. "\code{Maine}") or abbreviatons (e.g. "\code{ME}")}

\item{value_col}{column name in \code{state_data} that holds the values to be plotted}

\item{text_color}{default "\code{black}"}

\item{font_size}{font size (default = \code{3})}

\item{state_border_col}{default "\code{white}" - this creates the "spaces" between boxes}

\item{legend_title}{title for the legend}

\item{legend_position}{"\code{none}", "\code{top}", "\code{left}", "\code{right}" or "\code{bottom}" (defaults to "\code{top}")}

\item{brewer_pal}{which named \link{RColorBrewer} palette to use (defaults to "PuBu")}

\item{plot_title}{title for the plot}

\item{title_position}{where to put the title ("\code{bottom}" or "\code{top}" or "" for none); if "\code{bottom}", you get back a grob vs a ggplot object}
}
\value{
ggplot2 object or grob
}
\description{
\code{statebins()} creates "statebin" charts in the style of \url{http://bit.ly/statebins}
}
\details{
This version uses a continuous scale based on \link{RColorBrewer} scales
(passing in a 6 element \code{RColorBrewer} palette to \link{scale_fill_gradientn}).

The function minimally expects the caller to pass in a data frame that:

\itemize{
  \item has one column of all state abbreviationis (all caps, including \code{DC}) or a column of state names (standard capitalization) named \code{state}
  \item has another column of values named \code{value}
}

Doing so will create a "statebin" chart with 5 breaks and return a \link{ggplot2} object.

You can use a different column for the state names and values by changing \code{state_col}
and \code{value_col} accordingly.

To add a title, change \code{plot_title} to anything but an empty atomic string vector (i.e. \code{""})
and set \code{title_position} to "\code{top}" or "\code{bottom}". Choosing "\code{bottom}"
will cause \code{statebins} to use \link{arrangeGrob} to position the title via \code{sub} and
return a frame grob instead of a ggplot2 object.
}
\examples{
\dontrun{
data(USArrests)
USArrests$state <- rownames(USArrests)
statebins_continuous(USArrests, value_col="Murder", text_color="black", font_size=3,
                     legend_title = "Murder", legend_position="bottom")
}
}

