% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.panel.R
\name{is.panel}
\alias{is.panel}
\alias{is.panel_}
\title{Check whether a data.frame is a panel}
\usage{
is.panel(df, ...)

is.panel_(df, vars)
}
\arguments{
\item{df}{a data frame}

\item{...}{a list of variables. All except last are the id variable. Last is time variable}

\item{vars}{Used to work around non standard evaluation}
}
\value{
The function \code{is.panel} check that there are no duplicate combinations of the variables in ... and that no observation is missing for the last variable in ... (the time variable).
}
\description{
Check whether a data.frame is a panel
}
\examples{
library(dplyr)
df <- data_frame(
    id1    = c(1, 1, 1, 2, 2),
    id2   = 1:5,
    year  = c(1991, 1993, NA, 1992, 1992),
    value = c(4.1, 4.5, 3.3, 3.2, 5.2)
)
is.panel(df, id1, year)
df <- df \%>\% filter(!is.na(year))
is.panel(df, id1, year)
is.panel(df, id1, id2, year)
}

