% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stab_kang.R
\name{stab_kang}
\alias{stab_kang}
\alias{stab_kang.default}
\title{Stability Kang Function}
\usage{
stab_kang(.data, .y, .rep, .gen, .env)

\method{stab_kang}{default}(.data, .y, .rep, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\description{
Performs a stability analysis based on the Kang (1988)
             criteria. Kang nonparametric stability (ranksum) uses
             both "trait single value" and stability variance (Shukla, 1972),
             and the genotype with the lowest ranksum is commonly the most favorable one.
}
\examples{
data(ge_data)
YieldKang <-
     stab_kang(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
      )
YieldKang

}
\references{
\enumerate{
         \item  Kang, M.S.  (1988). A rank-sum method for selecting high-yielding, stable corn genotypes. \emph{Cereal Research Communications},  \strong{16}, 1-2.
         \item  Shukla, G.K.  (1972). Some aspects of partitioning genotype environmental components of variability. \emph{Heredity},  \strong{29}, 237-245.

         }
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         }
}
