% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ammi_biplot.R
\name{ammi_biplot}
\alias{ammi_biplot}
\alias{ammi_biplot.default}
\title{Additive Main Effects and Multiplicative Interaction (AMMI) Biplot}
\usage{
ammi_biplot(.data, .y, .rep, .gen, .env)

\method{ammi_biplot}{default}(.data, .y, .rep, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\value{
Stability Measures
}
\description{
Plots Additive Main Effects and Multiplicative Interaction (AMMI) for Genotypes by Environment Interaction (GEI)
}
\examples{

data(ge_data)
     ammi_biplot(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
      )



}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         }
}
