% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketRisk-base.R
\name{marketRisk}
\alias{marketRisk}
\title{Constructing a MarketRisk}
\usage{
marketRisk(cov.mat, mapping.table, initial.values, mapping.time, base.currency)
}
\arguments{
\item{cov.mat}{numeric matrix. The covariance matrix of the
market risk-factors. This matrix must have names, i.e. attributes
\code{colnames} and \code{rownames} indicating the names of the
corresponding narket risk-factors, please note that \emph{"participation"}
is a reserved name and should not be used. This matrix should also have
an attribute named "base.currency" indicating to which currency the fx rates
are mapped in the covariance matrix (use the function \code{attr()}).}

\item{mapping.table}{S3 object created using the constructor \code{mappingTable}.}

\item{initial.values}{list with the following elements:
\itemize{
  \item \code{initial.fx}: a data.frame with following columns and
  parameters:
    \itemize{
      \item \code{from}: a character value. The starting currencies.
      \item \code{to}: a character value. The arrival currencies.
      \item \code{fx}: a numeric value. The exchange rates from the
        starting currencies to the arrival currencies.
    }
  \item \code{initial.rate}: a data.frame with following columns and
  parameters:
    \itemize{
      \item \code{time}: an integer value. The terms for the interests.
      \item \code{currency}: a character value. The currencies for the interest rates.
     \item \code{rate}: a numeric value. The interest rates.
    }
}
Please note that you can directly use the constructors \code{\link{initialFX}} and
\code{\link{initialRate}} to provide these parameters.
to provide this parameter.}

\item{mapping.time}{a data.frame with following columns and parameters:
\itemize{
  \item \code{time-to-maturity}: an integer value. The times to maturities.
  \item \code{mapping}: character value. The mapping.
  \item \code{stringsAsFactors = FALSE}.
}
Please note that you can directly use the constructor \code{\link{mappingTime}}
to provide this parameter.}

\item{base.currency}{a character value of length one, the base currency of
the marketRisk.}
}
\value{
S3 object, instance of the class \code{marketRisk}.
}
\description{
\code{marketRisk} is the constructor for the S3 class
  marketRisk. It allows to build for market risk parameters.
}
\seealso{
\code{\link{mappingTable}}.
}
