% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wqg.R
\name{ssd_wqg_bc}
\alias{ssd_wqg_bc}
\title{Water Quality Guideline for British Columbia}
\usage{
ssd_wqg_bc(data, left = "Conc")
}
\arguments{
\item{data}{A data frame.}

\item{left}{A string of the column in data with the concentrations.}
}
\value{
A tibble of the 5\% hazard concentration with 95\% confidence intervals.
}
\description{
Calculates the 5\% Hazard Concentration for British Columbia
after rescaling the data
based on the log-logistic, log-normal and gamma distributions
using the parametric bootstrap and AICc model averaging.
}
\details{
Returns a tibble the model averaged 5\% hazard concentration with
standard errors, 95\% lower and upper confidence limits
and the number of bootstrap samples as well as the proportion of bootstrap
samples that successfully returned a likelihood
(convergence of the bootstrap sample is not required).
}
\examples{
\dontrun{
 ssd_wqg_bc(ssddata::ccme_boron)
}
}
\seealso{
\code{\link[=ssd_fit_dists]{ssd_fit_dists()}} and \code{\link[=ssd_hc]{ssd_hc()}}

Other wqg: 
\code{\link{ssd_wqg_burrlioz}()}
}
\concept{wqg}
