% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/llogis.R
\name{dllog}
\alias{dllog}
\alias{qllog}
\alias{pllog}
\alias{rllog}
\alias{sllog}
\alias{llogis}
\alias{dllogis}
\alias{qllogis}
\alias{pllogis}
\alias{rllogis}
\alias{sllogis}
\title{Log-Logistic Distribution}
\usage{
dllog(x, lshape = 0, lscale = 1, log = FALSE)

qllog(p, lshape = 0, lscale = 1, lower.tail = TRUE, log.p = FALSE)

pllog(q, lshape = 0, lscale = 1, lower.tail = TRUE, log.p = FALSE)

rllog(n, lshape = 0, lscale = 1)

sllog(x)

dllogis(x, lshape = 1, lscale = 1, log = FALSE)

qllogis(p, lshape = 1, lscale = 1, lower.tail = TRUE, log.p = FALSE)

pllogis(q, lshape = 1, lscale = 1, lower.tail = TRUE, log.p = FALSE)

rllogis(n, lshape = 1, lscale = 1)

sllogis(x)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{lshape}{shape parameter on the log scale.}

\item{lscale}{scale parameter on the log scale.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x],otherwise, P[X > x].}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Density, distribution function, quantile function, random generation
and starting values for the
log-logistic distribution
with \code{shape} and \code{scale} parameters.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dllogis(x), type = "l")
}
\seealso{
\code{\link[stats]{dlogis}}
}
