% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{srt_seconds}
\alias{srt_seconds}
\alias{srt_index}
\alias{srt_text}
\title{Parse components of a subtitle file}
\usage{
srt_seconds(x)

srt_index(x)

srt_text(x, collapse = "\\n")
}
\arguments{
\item{x}{A character vector with the lines of an \code{.srt} file.}

\item{collapse}{The character with which to separate subtitle lines.}
}
\value{
The parsed individual components of a subtitle: integer indexes,
numeric times, and collapsed string subtitles.
}
\description{
Parse components of a subtitle file
}
\examples{
# return individual components of each subtitle
x <- readLines(srt_example(1))
head(srt_seconds(x)[[1]])
head(srt_index(x))
head(srt_text(x))
}
