% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb2nb_order.R
\name{nb2nb_order}
\alias{nb2nb_order}
\title{A function to order the elements of the m_i-subrrounds}
\usage{
nb2nb_order(listw = listw, sf = NULL)
}
\arguments{
\item{listw}{an object of the nb class.}

\item{sf}{the sf object used to get the \code{listw} .}
}
\value{
An object of the nb class with the elements in order.
}
\description{
An auxiliary function. In the case of obtaining the list of neighbors of class
nb or \code{\link{poly2nb}}, it is necessary to reorder the elements based on distance and/or angle.
}
\details{
Sort the elements of a list nb. First by distance and
}
\examples{

# With a sf object (irregular lattice)
library(sf)
fname <- system.file("shape/nc.shp", package="sf")
nc <- sf::st_read(fname)
listw <- spdep::poly2nb(as(nc,"Spatial"), queen = FALSE)
listw.order <- nb2nb_order(listw = listw, sf = nc)

# With a sf object (regular lattice: hexagons)
sfc = sf::st_sfc(sf::st_polygon(list(rbind(c(0,0), c(1,0), c(1,1), c(0,1), c(0,0)))))
hexs <- sf::st_make_grid(sfc, cellsize = 0.1, square = FALSE)
hexs.sf <- sf::st_sf(hexs)
listw  <- spdep::poly2nb(as(hexs.sf, "Spatial"), queen = FALSE)
listw.order <- nb2nb_order(listw = listw, sf = hexs.sf)

}
\seealso{
\code{\link{dgp.spq}}, \code{\link{sp.runs.test}}, \code{\link{local.sp.runs.test}}
}
\author{
\tabular{ll}{
  Fernando López  \tab \email{fernando.lopez@upct.es} \cr
  Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
  Antonio Páez \tab \email{paez@gmail.com} \cr
  Manuel Ruiz \tab \email{manuel.ruiz@upct.es} \cr
  }
  @references
  \itemize{
    \item Ruiz, M., López, F., and Páez, A. (2021).
    A test for global and local homogeneity of categorical data based on spatial runs.
      \emph{Working paper}.
  }
}
