% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_funcs.R
\name{MaternCov}
\alias{MaternCov}
\title{Matern covariance function}
\usage{
MaternCov(grid, nu = 0.5, theta = 1, sig = 1)
}
\arguments{
\item{grid}{An \code{nx2} matrix of locations
over which to compute the covariance matrix or
an \code{nxn} matrix representing the distances
of the \code{n} planar points.}

\item{nu, theta, sig}{Matern model parameters. See details.}
}
\value{
A matrix representing the
covariance matrix for a random field (typically a GRF).
}
\description{
Computes the Matern covariance function. Used in the
creation of stationary and isotropic
Gaussian Random Fields (GRFs).

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#MaternCov}
}
\details{
The Matern covariance model
for two points with Euclidean
distance r, is given by

C(r) = sig^2 2^(1-nu) gamma(nu)^(-1) (sqrt(2nu) r/theta)^nu B_nu(sqrt(2nu) r/theta)

where sig, theta, nu>0, and B_nu is the
modified Bessel function of second kind. Note that
the Matern for nu=.5 reduces to the exponential.
}
\examples{

\dontrun{
grid=cbind(seq(0,1,length=10), seq(0,1,length=10))
MaternCov(grid)}

}
\author{
Sakis Micheas
}
\seealso{
\code{\link{rGRF}}
}

