% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moransi.R
\name{UnivariateMoransI}
\alias{UnivariateMoransI}
\title{Univariate Moran's I}
\usage{
UnivariateMoransI(
  X,
  W,
  normalize = TRUE,
  alternative = c("two.sided", "less", "greater"),
  p.adjust.method = "BH"
)
}
\arguments{
\item{X}{A matrix with observations as rows and features as columns.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{normalize}{Whether to normalize the weight matrix such that each row adds up to one. Default is \code{TRUE}.}

\item{alternative}{Alternative hypothesis used, default is \code{two.sided}.}

\item{p.adjust.method}{Method used for multiple comparisons correction, default is \code{BH}. See \code{\link[stats]{p.adjust}}.}
}
\value{
A list containing the following:
\itemize{
\item Morans.I, the Moran's I.
\item Z.I, the Z score of Moran's I.
\item X, data matrix used for calculating Moran's I.
\item Y, a matrix of spatial lags.
\item Expected.I, the expectation of Moran's I under the null hypothesis.
\item SD.I, the standard deviation of Moran's I under the null hypothesis.
\item p.val, p-values.
\item p.adj, adjusted p-values.
\item normalize, whether to normalize the weight matrix.
\item alternative, alternative hypothesis used.
\item p.adjust.method, method used for multiple comparisons correction.
}
}
\description{
Calculate univariate (canonical) Moran's I.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- UnivariateMoransI(data.use[,3:4], W)
}
}
\references{
Moran, P. A. P. Notes on continuous stochastic phenomena. Biometrika 37, 17–23 (1950)
}
\concept{moransi}
